(* dict.inc --    writedict  readdict *)
{$i dict.inc}

function readdict (const indictname:pchar;inlist:pdict_elem;
	            maxlength:integer):pdict_elem;
var
  i:integer;
  inf:pfile;                
begin
  (*    *)
  inf := fopen (indictname, 'r');
  if inf = nil then
  begin
    readdict:=nil;
    exit;
  end;
  (*   dict_elem   *)
  for i:=0 to maxlength - 1 do
    if fread (@inlist[i], sizeof (dict_elem), 1, inf) < 1 then
      break;
  fclose (inf);
  (*    *)
  inlist[i].d_length := 0;
  (*    *)
  readdict:=inlist;
end;


function writedict (const dictname:pchar; elist:pdict_elem):integer;
var
  j:integer;
  outf:pfile;
begin
  (*    *)
  outf := fopen (dictname, 'w');
  if outf = nil then
  begin
    writedict:=ERROR;
    exit;
  end;
  (*    *)
  j:=0;
  while elist[j].d_length <> 0 do
    inc(j);
  (*    dict_elem *)
  if fwrite (elist, sizeof (dict_elem), j, outf) < j then
  begin
    fclose (outf);
    writedict:=ERROR;
    exit;
  end;
  fclose (outf);
  writedict:=SUCCESS;
end;


const
  delem1:array [0..1] of dict_elem=(
    (d_name:('d', 'n', 'a', 'm', 'e', #0, #0, #0, #0, #0, #0, #0, #0, #0, #0); 
     d_start:2; d_length:15; d_type:3),
    (d_name:(#0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0); 
     d_start:0; d_length:0; d_type:0)
  );
var
  delem2:array [0..1] of dict_elem;
begin
  printf ('delem1: d_name = %s, d_start = %d, d_length = %d, d_type = %d'#$a,
	    [pchar(delem1[0].d_name), delem1[0].d_start, delem1[0].d_length, delem1[0].d_type]);
  writedict ('dictionary', @delem1[0]);
  if readdict ('dictionary', @delem2[0], 2)<>nil then
    printf ('delem2: d_name = %s, d_start = %d, d_length = %d, d_type = %d'#$a,
	    [pchar(delem2[0].d_name), delem2[0].d_start, delem2[0].d_length, delem2[0].d_type]);
end.
