(*   *)
uses sockets,stdio,linux;

const
  SIZE=sizeof(tinetsockaddr);
  server:tinetsockaddr = (family:AF_INET; port:7000; addr:INADDR_ANY);
  
var
  newsockfd:longint;

procedure catcher (sig:integer);cdecl;
begin
  fdclose (newsockfd);
  halt (0);
end;

var
  sockfd:longint;
  c:char;
  act:sigactionrec;
  mask:sigset_t;
  client:tinetsockaddr;
  clientaddrlen:longint;
begin
  act.handler.sh := @catcher;
  sigfillset (@mask);
  act.sa_mask:=mask.__val[0];
  sigaction (SIGPIPE, @act, nil);

  (*     *)
  sockfd := socket (AF_INET, SOCK_STREAM, 0);
  if sockfd = -1 then
  begin
    perror ('  socket');
    halt (1);
  end;

  (*      *)
  if not bind (sockfd, server, SIZE) then
  begin
    perror ('  bind');
    halt (1);
  end;

  (*    *)
  if not listen (sockfd, 5) then
  begin
    perror ('  listen');
    halt (1);
  end;

  while true do
  begin
    (*     *)
    newsockfd := accept (sockfd, client, clientaddrlen);
    if newsockfd = -1 then
    begin
      perror ('  accept');
      continue;
    end;

    (*        *)
    if fork = 0 then
    begin
      while recv (newsockfd, c, 1, 0) > 0 do
      begin
        c := upcase (c);
        send (newsockfd, c, 1, 0);
      end;

      (*  ,     ,
       *       
       *   *)
      fdclose (newsockfd);
      halt (0);
    end;

    (*    newsockfd   *)
    fdclose (newsockfd);
  end;
end.
