unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  Buttons, ComCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    LabeledEdit1: TLabeledEdit;
    LabeledEdit2: TLabeledEdit;
    LabeledEdit3: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    StatusBar1: TStatusBar;
    procedure FormShow(Sender: TObject);
    procedure LabeledEdit1KeyPress(Sender: TObject; var Key: char);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.FormShow(Sender: TObject);
begin
  LabeledEdit1.SetFocus;
end;
procedure TForm1.LabeledEdit1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
  begin
    try
      StrToInt(LabeledEdit1.Text);
    except
      on EConvertError do
      begin
        ShowMessage('Ошибка преобразования! Вероятно, ' +
                    'Вы ошиблись при вводе числа');
        exit;
      end;
    end;
    LabeledEdit2.SetFocus;
    SpeedButton1.Down:= false;
    SpeedButton2.Down:= false;
    SpeedButton3.Down:= false;
    SpeedButton4.Down:= false;
    exit;
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  try
    LabeledEdit3.Text:= IntToStr(StrToInt(LabeledEdit1.Text)
                      + StrToInt(LabeledEdit2.Text));
  except
    on EConvertError do
    begin
      ShowMessage('Ошибка преобразования! Вероятно, ' +
                  'Вы ошиблись при вводе второго числа');
      exit;
    end;
  end;
  StatusBar1.SimpleText:= 'Сложение';
  LabeledEdit1.SetFocus;
  LabeledEdit1.SelectAll;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  try
  LabeledEdit3.Text:= IntToStr(StrToInt(LabeledEdit1.Text)
                    - StrToInt(LabeledEdit2.Text));
  except
    on EConvertError do
    begin
      ShowMessage('Ошибка преобразования! Вероятно, ' +
                  'Вы ошиблись при вводе второго числа');
      exit;
    end;
  end;
  StatusBar1.SimpleText:= 'Вычитание';
  LabeledEdit1.SetFocus;
  LabeledEdit1.SelectAll;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  try
    LabeledEdit3.Text:= IntToStr(StrToInt(LabeledEdit1.Text)
                      * StrToInt(LabeledEdit2.Text));
  except
    on EConvertError do
    begin
      ShowMessage('Ошибка преобразования! Вероятно, ' +
                  'Вы ошиблись при вводе второго числа');
      exit;
    end;
  end;
  StatusBar1.SimpleText:= 'Умножение';
  LabeledEdit1.SetFocus;
  LabeledEdit1.SelectAll;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  try
    LabeledEdit3.Text:= IntToStr(StrToInt(LabeledEdit1.Text) div
                        StrToInt(LabeledEdit2.Text));
  except
    on EConvertError do
    begin
      ShowMessage('Ошибка преобразования! Вероятно, ' +
                  'Вы ошиблись при вводе второго числа');
      exit;
    end;
    on EDivByZero do
    begin
      ShowMessage('Ошибка! Произошло деление на ноль. Вероятно, ' +
                  'Вы ошиблись при вводе второго числа');
      exit;
    end;
  end;
  StatusBar1.SimpleText:= 'Деление нацело';
  LabeledEdit1.SetFocus;
  LabeledEdit1.SelectAll;
end;

initialization
  {$I unit1.lrs}

end.
