unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: char);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }


procedure TForm1.Button1Click(Sender: TObject);
begin
  Edit1.SetFocus;
  if (Edit1.Text <> '') and     // если пустая строка
     (Edit1.Text <> '-') and    // если одиночный минус
     (Edit1.Text <> DecimalSeparator) and // если одиночный разделитель
     (Edit1.Text <> '-' + DecimalSeparator) // если "-" и разделитель
  then Edit2.Text:= FloatToStr(StrToFloat(Edit1.Text));
  Edit1.Clear;
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: char);
begin
  case Key of

    '0'..'9', #8:;  // если цифры и кл. BackSpace, ввод разрешен
    #13: // если нажата клавиша <Enter>
      begin
        if (Edit1.Text <> '') and
           (Edit1.Text <> '-') and
           (Edit1.Text <> DecimalSeparator) and
           (Edit1.Text <> '-' + DecimalSeparator)
        then
          Edit2.Text:= FloatToStr(StrToFloat(Edit1.Text));
        Edit1.SetFocus;
        Edit1.Clear;
      end;

    '.',',':  // если разделители
    begin
      if Key <> DecimalSeparator then
      Key := DecimalSeparator; // замена разделителя
      if Pos(DecimalSeparator, Edit1.Text) <> 0
      then Key:= #0;
    end;

    '-' :  // если знак минус
    begin
    if (Edit1.SelStart <> 0)  // если одиночный минус
    then
    begin
      Key:= #0;
      exit;
    end
    else
      if (Pos('-', Edit1.Text) <> 0) // два минуса недопустимы
      then  Key:= #0;
    end;
  else
  Key := #0;
  end;
end;


initialization
  {$I unit1.lrs}

end.

