unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function Search(str: string): boolean;
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }
function TForm1.Search(str: string): boolean;
var
  i: integer;
begin
  Result:= false;
  for i:= 0 to ListBox2.Count - 1 do
  if ListBox2.Items.Strings[i] = str then
  begin
    Result:= true;
    exit;
  end
  else Result:= false;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  i: integer;
begin
  with ListBox1 do
  for i:= 0 to Items.Count - 1 do
  begin
    if (Selected[i]) and (not Search(Items.Strings[i]))
    then
      ListBox2.Items.Add(Items.Strings[i]);
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ListBox2.Clear;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile('List.txt');
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  with ListBox1 do
  begin
    Items.Text:= str;
  end;
  tfile.Free;
  ListBox1.MultiSelect:= true;
  ListBox2.Sorted:= true;
end;

initialization
  {$I unit1.lrs}

end.

