program stack;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil;
type
  c = ^MyStack; // указатель
  MyStack = record // структура записи
  data: integer; // содержательная часть стека
  next: c; // ссылка на следующий элемент
  end;
var
  choose: integer;
  EMPTY: boolean;
  CTEK: c; // указатель, указывает на вершину стека
  ukaz: c; // рабочий указатель
  ELEM: integer; // содержательный элемент стека
{ ================================================ }
procedure Put_Stack(var ELEM: integer; var CTEK: c);
{ ================================================ }

begin
  New(ukaz); // создаем новый элемент стека
  ukaz^.data:= ELEM; // В поле data записи записываем значение
  ukaz^.next:= CTEK; // ссылка на следующий элемент
  CTEK:= ukaz; // вершиной стека становится новый элемент
end;

{ ================================================ }
procedure Take_Stack(var ELEM: integer; var CTEK: c;
                     var EMPTY: Boolean);
{ ================================================ }
var ukaz: c;
begin
  if CTEK <> nil then
  begin
    ELEM:= CTEK^.data; // Берем элемент из вершины стека
    ukaz:= CTEK^.next; // Указатель на следующий элемент
    Dispose(CTEK); // уничтожение текущей вершины
    CTEK:= ukaz;  // вершиной стека становится следующий элемент
  end
  else EMPTY:= true;
end;
procedure View_Stack(var CTEK: c);
var ukaz: c;
begin
  writeln(UTF8ToConsole('Содержимое стека'));
  ukaz:= CTEK; // Берем вершину стека
  {В цикле проходим все элементы стека и печатаем их}
  while ukaz <> nil do
  begin
    write(ukaz^.data, ' ');
    ukaz:= ukaz^.next;
  end;
  writeln;
end;

begin
  {Инициализация стека}
  CTEK:= nil;
  repeat
    EMPTY:= false;
    writeln(UTF8ToConsole('Выберите нужный режим работы :'));
    writeln(UTF8ToConsole('Поместить элемент в стек     1'));
    writeln(UTF8ToConsole('Взять элемент из стека       2'));
    writeln(UTF8ToConsole('Просмотреть содержимое стека 3'));
    writeln(UTF8ToConsole('Выход из программы           4'));
    readln(choose);
    case choose of
    1: begin
         writeln(UTF8ToConsole('Введите новый элемент стека'));
         readln(ELEM);
         Put_Stack(ELEM, CTEK);
       end;
    2: begin
         Take_Stack(ELEM, CTEK, EMPTY);
         if EMPTY then
         begin
           writeln(UTF8ToConsole('Стек пуст'));
         end
         else
         begin
           writeln(UTF8ToConsole('Из верхушки стека взят элемент '), ELEM);
         end;
       end;
    3:begin
        View_Stack(CTEK);
      end;
    end; { end of case }
  until choose = 4;
end.
