program search_in_file;
uses
  CRT, FileUtil, SysUtils, OutScr;
type
    manager= record
    name: string[18];
    comp: integer;
 end;
var
  company: manager;
  f_not_sorted: File of manager; // Файловая переменная
  vector: array of manager;
  i, n: integer;
  name_file: string;
  name_manager: string;

  { =============    Линейный поиск ======== }
function LinearSearch(var not_sorted_array:array of manager;
                      name_manager: string): integer;
var
  i: integer;
begin
  for i:= 0 to High(not_sorted_array) do
  begin
    if name_manager = not_sorted_array[i].name then
    begin
      LinearSearch := i;
      exit;
    end;
  end;
LinearSearch:= -1;
end;
{  ================================================ }

begin
  {При необходимости укажите полный путь к файлу
   или скопируйте файл в папку с данным проектом}
  if not FileExists('File_not_sorted.dat') then
  begin
    writeln(UTF8ToConsole('Файл не существует'));
    writeln(UTF8ToConsole('Сначала создайте его'));
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    exit;
  end;
  AssignFile(f_not_sorted,'File_not_sorted.dat');
  Reset(f_not_sorted);
  // Определение количества записей в файле
  n:= System.FileSize(f_not_sorted);
  SetLength(vector, n);
  {Подготовка поиску,
  считывание записей файла в массив,
  в функцию передается массив, а не файл.}
  i:= 0;
  while not Eof(f_not_sorted) do
  begin
     Read(f_not_sorted, company);
     vector[i]:= company;  // массив, в которым будет вестись поиск
     i:= i + 1;
  end;
  CloseFile(f_not_sorted);
  writeln(UTF8ToConsole('Введите фамилию менеджера'));
  readln(name_manager);
  {вызов функции поиска}
  n:= LinearSearch(vector, name_manager);
  name_file:= 'File_not_sorted.dat';
  {Вызов процедуры для вывода на экран списка менеджеров.
  Процедура находится в модуле OutScr}
  output_to_screen(name_file);
  if n= -1 then
     writeln(UTF8ToConsole('Такого менеджера нет'))
  else
     writeln(UTF8ToConsole('Менеджер найден, его номер в файле '), n+1);
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.

