program insertion_sort_file;
uses
  CRT, SysUtils, OutScr, FileUtil;
type
  manager=record
  name:string[18];
  comp: integer;
 end;
var
  company: manager;
  f_not_sorted, f_sorted: File of manager; // Файловая переменная
  vector: array of manager;
  i, n: integer;
  name_file: string;
  
{Процедура сортировки методом вставок файла по фамилиям менеджеров }
procedure insert(var vector: array of manager);
var
  i, j, count: integer;
  t: manager;
begin
  count:= high(vector);
  for i:= 0 to count do
  begin
    t:= vector[i];
    j:= i - 1;
    while (vector[j].name > t.name) and (j >= 0) do
    begin
      vector[j + 1] := vector[j];
      dec(j);
    end;
    vector[j + 1] := t;
  end;
end;
{  ====================================================== }

begin
  {При необходимости укажите полный путь к файлу
   или скопируйте файл в папку с данным проектом}
  if not FileExists('File_not_sorted.dat') then
  begin
    writeln(UTF8ToConsole('Файлы не существуют'));
    writeln(UTF8ToConsole('Сначала создайте их'));
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    exit;
  end;
  AssignFile(f_not_sorted, 'File_not_sorted.dat');
  Reset(f_not_sorted);
  n:= System.FileSize(f_not_sorted); // Определение количества записей в файле
  SetLength(vector, n);
  {Подготовка к внутренней сортировке,
  считывание записей файла в массив,
  в процедуру передается массив, а не файл.}
  i:= 0;
  while not Eof(f_not_sorted) do
  begin
     Read(f_not_sorted, company);
     vector[i]:= company;  // массив, который будет сортироваться
     i:= i + 1;
  end;
  insert(vector); // вызов процедуры сортировки методом вставок
  CloseFile(f_not_sorted);
  AssignFile(f_sorted, 'File_sorted.dat');
  Rewrite(f_sorted);
  for i:= 0 to n - 1 do
  Write(f_sorted, vector[i]);
  CloseFile(f_sorted);
  name_file:= 'File_sorted.dat';
  {Вызов процедуры для вывода на экран сводной ведомости.
  Процедура находится в модуле OutScr}
  output_to_screen(name_file);
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.
