program quick_sort_file;
uses
  CRT, FileUtil, SysUtils, OutScr;
type
  manager= record
  name: string[18];
  comp: integer;
 end;
var
  company: manager;
  f_not_sorted, f_sorted: File of manager; // Файловая переменная
  vector: array of manager;
  i, n: integer;
  name_file: string;

  { =============    Метод быстpой сортировки ======== }
procedure QuickSort(var sorted_array: array of manager);

  { rec_sort - рекурсивная процедура }
procedure rec_sort(first, last: integer;
                   var sorted_array: array of manager);
 { first, last - первый и последний элементы текущей группы }
var
  i: integer; // указатель для левого списка
  j: integer;  // указатель для правого списка
  middle: manager; // средний элемент списка
  temp: manager;
begin
  while (first < last) do
  begin
    middle:= sorted_array[(first + last) div 2];
    i:= Pred(first);
    j:= Succ(last);
    while true do
    begin
      repeat dec(j);
      until sorted_array[j].name <= middle.name;
      repeat inc(i);
      until sorted_array[i].name >= middle.name;
      if i >= j then break;
      temp:= sorted_array[i];
      sorted_array[i]:= sorted_array[j];
      sorted_array[j]:= temp;
      end;
  {рекурсивный вызов процедуры}
  if first < j then rec_sort(first, j, sorted_array);
  first:= Succ(j);
  end;
end;
 { ==================================================== }
begin
  { первый вызов рекурсивной процедуры}
  rec_sort(0, n - 1, sorted_array);
end;
{  ====================================================== }

begin
  {При необходимости укажите полный путь к файлу
   или скопируйте файл в папку с данным проектом}
  if not FileExists('File_not_sorted.dat') then
  begin
    writeln(UTF8ToConsole('Файлы не существуют'));
    writeln(UTF8ToConsole('Сначала создайте их'));
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    exit;
  end;
  AssignFile(f_not_sorted, 'File_not_sorted.dat');
  Reset(f_not_sorted);
  // Определение количества записей в файле
  n:= System.FileSize(f_not_sorted);
  SetLength(vector, n);
  {Подготовка к внутренней сортировке,
  считывание записей файла в массив,
  в процедуру передается массив, а не файл.}
  i:= 0;
  while not Eof(f_not_sorted) do
  begin
     Read(f_not_sorted, company);
     vector[i]:= company;  // сортируемый массив
     i:= i + 1;
  end;
  QuickSort(vector); // вызов процедуры быстрой сортировки
  CloseFile(f_not_sorted);
  AssignFile(f_sorted, 'File_sorted.dat');
  Rewrite(f_sorted);
  for i:= 0 to n - 1 do
  Write(f_sorted, vector[i]);
  CloseFile(f_sorted);
  name_file:= 'File_sorted.dat';
  {Вызов процедуры для вывода на экран сводной ведомости.
  Процедура находится в модуле OutScr}
  output_to_screen(name_file);
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.
