program quick_sort;
uses
  CRT, FileUtil;
type
  vector= array of integer;
var
  i, n: integer;
  sorted_array: vector; // сортируемый массив
  
  { =============    Метод быстpой сортировки ======== }
procedure QuickSort(var sorted_array: vector);

  { rec_sort - рекурсивная процедура }
procedure rec_sort(first, last: integer;
                   var sorted_array: vector);
 { first, last - первый и последний элементы текущей группы }
var
  i: integer; // указатель для левого списка
  j: integer;  // указатель для правого списка
  middle: integer; // средний элемент списка
  temp: integer;
begin
  while (first < last) do
  begin
    middle:= sorted_array[(first + last) div 2];
    i:= pred(first);
    j:= succ(last);
    while true do
    begin
      repeat dec(j);
      until sorted_array[j] <= middle;
      repeat inc(i);
      until sorted_array[i] >= middle;
      if i >= j then break;
      temp:= sorted_array[i];
      sorted_array[i]:= sorted_array[j];
      sorted_array[j]:= temp;
      end;
  {рекурсивный вызов процедуры}
  if first < j then rec_sort(first, j, sorted_array);
  first:= succ(j);
  end;
end;
  { ======= конец процедуры rec_sort ======== }
begin
  { первый вызов рекурсивной процедуры}
  rec_sort(0, n - 1, sorted_array);
end;
  { ======= конец процедуры QuickSort ======== }
begin
  writeln(UTF8ToConsole('Введите количество элементов массива'));
  readln(n);
  SetLength(sorted_array, n);
  writeln(UTF8ToConsole('Введите элементы массива'));
  for i:= 0 to n - 1 do
    read(sorted_array[i]);
  QuickSort(sorted_array);
  writeln(UTF8ToConsole('Отсортированный массив:'));
  writeln;
  for i:= 0 to n - 1 do
    write(sorted_array[i], ' ');
  writeln;
  writeln;
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.


