program Database_Student;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil, SysUtils, LConvEncoding, LCLType;
type
  student = record   // тип запись
  fio: string[24];   // фамилия
  predmet: string[32]; // предмет
  gruppa: string[24]; // группа
  ocenka: integer;
end;

  fstud = File of student;

var
  fam: string[24]; // фамилия
  sub: string[32]; // предмет
  gr: string[24]; // группа
  answ: TUTF8Char; // одиночный символ для приема ответа пользователя
  f, v: fstud; {f,v   -   файловые переменные,
  где f - имя основного файла;
  v - имя вспомогательного файла}
  new_student: student;
  choice,choose, ocen: integer; {переменные,
  предназначенные для выбора режима}
  fname: string; {строковая переменная,
  имя файла на диске без расширения}
  full_fname: string; {строковая переменная,
  полное имя файла на диске с расширением}
  code_error: integer; // код ошибки ввода/вывода

// опережающее объявление функций и процедур
procedure Reset_File( var f: fstud); forward;
procedure Read_File(var f: fstud;
                    var st: student); forward;
procedure Write_File(var f: fstud;
                     var st: student); forward;
procedure check_file; forward;

{ ================ Ввод данных ================ }
procedure input_data;
begin
  with new_student do
  begin
    writeln(UTF8ToConsole('  Фамилия   '));
    readln(fio);
    writeln(UTF8ToConsole('  Группа    '));
    readln(gruppa);
    writeln(UTF8ToConsole('  Предмет  '));
    readln(predmet);
    writeln(UTF8ToConsole('  Оценка    '));
    repeat
      {$I-}
      readln(ocenka);
      {$I+}
      if (IOResult <> 0) or ((ocenka > 5)
       or (ocenka < 1)) then
      begin
        writeln(UTF8ToConsole('Оценкой может быть целое число от 1 до 5'));
      end;
    until (ocenka >= 1) and (ocenka <= 5);
  end;
end;

{ ================ Создание файла ================ }
procedure create_data;
begin
  check_file;
  Rewrite(f);
  writeln(UTF8ToConsole('  Введите данные '));
  repeat
  input_data;
  Write(f, new_student);
  writeln(UTF8ToConsole('  Продолжить?, ответ - д/н (y/n) '));
  readln(answ);
  {$IFDEF WINDOWS}
    answ:= CP866ToUTF8(answ);
  {$ENDIF}
  until (answ= 'N') or (answ= 'n') or (answ= 'н') or (answ= 'Н');
end;

procedure check_file;
var
answ: TUTF8char;
begin
  if FileExists(full_fname) then
  begin
    Assign(f, full_fname);
    Reset(f);
    writeln(UTF8ToConsole('Текущий файл будет уничтожен!!'));
    writeln(UTF8ToConsole('Если вы хотите стереть существующий '));
    writeln(UTF8ToConsole('файл, нажмите клавишу Esc,'));
    writeln(UTF8ToConsole('иначе нажмите любую клавишу.'));
    repeat
      answ:= readkey;
        if answ= #27 then
        begin
          writeln(UTF8ToConsole('Вы уверены? Нажмите '));
          writeln(UTF8ToConsole('еще раз клавишу Esc'));
          writeln(UTF8ToConsole('Для отмены нажмите '));
          writeln(UTF8ToConsole('любую клавишу.'));
          answ:= readkey;
          if answ = #27 then
            break;
        end;
        writeln(UTF8ToConsole('Введите другое имя файла'));
        CloseFile(f);
        readln(fname);
        Assign(f, fname +' .dat');
        break;
    until answ = #27;
  end;
end;

{ ================ Вывод  содержимого файла ================ }
procedure out_to_screen;
var j: integer;
begin
  Reset_File(f);
  ClrScr;
  GoToXY(1, 5);
  j:= 0;
  writeln(UTF8ToConsole('*  фамилия   *   группа   *     предмет    * оценка *'));
  writeln('=====================================================');
  while not Eof(f) do
  begin
    read(f,new_student);
    j:= j + 1;
    GoToXY(2, 6 + j);
    writeln(new_student.fio);
    GoToXY(15, 6 + j);
    writeln(new_student.gruppa);
    GoToXY(28, 6 + j);
    writeln(new_student.predmet);
    GoToXY(48, 6 + j);
    writeln(new_student.ocenka);
  end;
  writeln('=====================================================');
  writeln(UTF8ToConsole(' Число студентов='),j:2);
  writeln(UTF8ToConsole('Для продолжения нажмите любую клавишу '));
  readkey;
end;

{ ========= Поиск записей по заданным полям ============ }
procedure select_data;
begin
  repeat
  Reset_File(f);
  ClrScr;
  GoToXY(10, 10); write  (UTF8ToConsole('Выбор информации по:'));
  GoToXY(10, 11); write  (UTF8ToConsole('  группе            - 1'));
  GoToXY(10, 12); write  (UTF8ToConsole('  предмету          - 2'));
  GoToXY(10, 13); write  (UTF8ToConsole('  оценке            - 3'));
  GoToXY(10, 14); writeln(UTF8ToConsole('  выход из режима   - 4'));
  readln(choice);
  ClrScr;
  case choice of
    1: begin
         write(UTF8ToConsole(' Группа -'));
         readln(gr);
         writeln(UTF8ToConsole(' Сведения по группе '), UTF8ToConsole(gr):5);
       end;
    2: begin
         write(UTF8ToConsole(' Предмет -'));
         readln(sub);
         writeln(UTF8ToConsole(' Сведения по предмету '), UTF8ToConsole(sub):15);
       end;
    3: begin
         write(UTF8ToConsole(' Оценка ='));
         readln(ocen);
         writeln(UTF8ToConsole(' Сведения по оценке  '),ocen:1);
       end;
  else
    exit;
  end; { end of case }
  while not eof(f) do
  begin
    Read_File(f,new_student);
    case choice of
      1: if new_student.gruppa=gr then writeln(new_student.fio:15,
         ' ',new_student.predmet:15,' ',new_student.ocenka:1);
      2: if new_student.predmet=sub then writeln(new_student.fio:15,
         ' ',new_student.gruppa:15,' ',new_student.ocenka:1);
      3: if new_student.ocenka=ocen then writeln(new_student.fio:15,
         ' ',new_student.predmet:15,' ',new_student.gruppa:5);
    end; { end of case }
  end; { end of while }
  GoToXY(5, 24);
  writeln(UTF8ToConsole('Для продолжения нажмите любую клавишу '));
  readkey;
  until choice = 4;
end;

{ ======== Восстановление файла под основное имя f ========== }
procedure restorefile;
begin
  CloseFile(f);
  CloseFile(v);
  Erase(f);
  Rewrite(f);
  Reset(v);
  while not Eof(v) do
  begin
    Read_File(v, new_student);
    Write_File(f, new_student);
  end;
  CloseFile(f); CloseFile(v); Erase(v);
    { удален вспомогательный файл v под внешним именем s.dat }
end;

{ ================ Добавление записей в файл ================ }
procedure add_data;
begin
  Assign(v, 's.dat');
  Rewrite(v);
  { "s.dat" - имя вспомогательного файла }
  Reset_File(f);

  { копирование содержимого файла f в файл v }
  while not Eof(f) do
  begin
    Read_File(f, new_student);
    Write_File(v, new_student);
  end;
  writeln(UTF8ToConsole('  Вводите информацию '));
  { записи добавляются в конце файла }
  repeat
    input_data;
    Write_File(v, new_student);
    writeln(UTF8ToConsole('  Продолжить?, ответ - д/н (y/n) '));
    readln(answ);
    {$IFDEF WINDOWS}
     answ:= CP866ToUTF8(answ);
    {$ENDIF}
  until (answ= 'N') or (answ= 'n') or (answ = 'н') or (answ = 'Н');
  restorefile;
end;

{ ================ Удаление записей из файла ================ }
procedure delete_data;
begin
  Assign(v, 's.dat'); Rewrite(v); Reset(f);
  ClrScr;
  GoToXY(10, 10); writeln(UTF8ToConsole('Удаление информации по:'));
  GoToXY(10, 11); writeln(UTF8ToConsole('  группе            - 1'));
  GoToXY(10, 12); writeln(UTF8ToConsole('  фамилии           - 2'));
  GoToXY(10, 13); writeln(UTF8ToConsole('  предмету          - 3'));
  GoToXY(10, 14); writeln(UTF8ToConsole('  оценке            - 4'));
  GoToXY(10, 15); writeln(UTF8ToConsole('  выход из режима   - 5'));
  GoToXY(10, 16);   write(UTF8ToConsole('  выбор режима ='));
  readln(choice);
  case choice of
    1: begin write(UTF8ToConsole(' Группа  - ')); readln(gr); end;
    2: begin write(UTF8ToConsole(' Фамилия - ')); readln(fam); end;
    3: begin write(UTF8ToConsole(' Предмет - ')); readln(sub); end;
    4: begin write(UTF8ToConsole(' Оценка  - ')); readln(ocen);   end;
    5: exit; { выход в основную программу }
  end; { end of case }

{ ========= поиск записи для удаления =========== }
  while not Eof(f) do
  begin
    Read_File(f, new_student);
    case choice of
      1: if new_student.gruppa<>gr then Write_File(v,new_student);
      2: if new_student.fio<>fam then Write_File(v,new_student);
      3: if new_student.predmet<>sub then Write_File(v,new_student);
      4: if new_student.ocenka<>ocen then Write_File(v,new_student);
         else
         begin
           writeln(UTF8ToConsole(' Ошибка при вводе '));
           writeln(UTF8ToConsole('Для продолжения нажмите любую клавишу '));
           readkey;
         end;
    end; { end of case }
  end; { end of while }
  restorefile;
end;

{ ========== процедура открытия файла с контролем операции ============ }
procedure Reset_File( var f:fstud);
begin
  {$I-}
  Reset(f);
  {$I+}
  code_error:= IOResult;
  if code_error <> 0 then
  begin
    writeln(UTF8ToConsole('Файл не существует, код ошибки '), code_error);
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    Halt;
  end;
end;

{ ========== процедура чтения с контролем операции ============ }
procedure Read_File(var f: fstud; var st: student);
begin
  {$I-}
  Read(f, st);
  {$I+}
  code_error:= IOResult;
  if code_error <> 0 then
  begin
    writeln(UTF8ToConsole('Ошибка чтения из файла, код ошибки '), code_error);
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    Halt;
  end;
end;

{ ========== процедура записи с контролем операции ============ }
procedure Write_File(var f: fstud; var st: student);
begin
  {$I-}
  Write(f, st);
  {$I+}
  code_error:= IOResult;
  if code_error <> 0 then
  begin
    writeln(UTF8ToConsole('Ошибка записи в файл, код ошибки '), code_error);
    writeln(UTF8ToConsole('Нажмите любую клавишу'));
    readkey;
    Halt;
  end;
end;

{ ================ корректировка записей в файле =============== }
procedure find_data;
var r: student;
begin
  Reset_File(f);  Assign(v,'s.dat'); Rewrite(v);
  ClrScr;
  GoToXY(10, 9); writeln(UTF8ToConsole('Укажите ключ (поле)для поис-ка'));
  GoToXY(10, 10);writeln(UTF8ToConsole('корректируемой записи - по:'));
  GoToXY(10, 11); writeln(UTF8ToConsole('  группе            - 1'));
  GoToXY(10, 12); writeln(UTF8ToConsole('  фамилии           - 2'));
  GoToXY(10, 13); writeln(UTF8ToConsole('  предмету          - 3'));
  GoToXY(10, 14); writeln(UTF8ToConsole('  оценке            - 4'));
  GoToXY(10, 15); writeln(UTF8ToConsole('  выход из режима   - 5'));
  GoToXY(10, 16);   write(UTF8ToConsole('  выбор режима ='));
  readln(choice); ClrScr;
  GoToXY(10, 9);  writeln(UTF8ToConsole('  Замена информации   '));
  case choice of   {   поиск записи  }
    1: begin
         GoToXY(10, 10);
         write(UTF8ToConsole('группа='));
         readln(gr);
         input_data;
       end;
    2: begin
        GoToXY(10, 10);
        write(UTF8ToConsole('фамилия='));
        readln(fam);
        input_data;
      end;
    3: begin
        GoToXY(10, 10);
        write(UTF8ToConsole('предмет='));
        readln(sub);
        input_data;
      end;
    4: begin
        GoToXY(10, 10);
        write(UTF8ToConsole('оценка='));
        readln(ocen);
        input_data;
      end;
    5: exit; { выход в основную программу }
  end; { end of case }
  while not Eof(f) do
  begin
    Read_File(f, r);
    case choice of
      1: begin
           if gr=r.gruppa then Write_File(v,new_student)
           else Write_File(v,r)
         end;
      2: begin
           if fam=r.fio then Write_File(v,new_student)
           else Write_File(v,r)
         end;
      3: begin
           if sub=r.predmet then Write_File(v,new_student)
           else Write_File(v,r)
         end;
      4: begin
           if ocen=r.ocenka then Write_File(v,new_student)
           else Write_File(v,r)
         end;
    end; { end of case }
  end; { end of while }
  restorefile;
end;

   { ============== основная программа ====================}
begin
  writeln(UTF8ToConsole('Введите имя файла:'));
  readln(fname);
  {$IFDEF WINDOWS}
    fname:=CP866ToUTF8(fname);
    fname:=UTF8ToAnsi(fname);
  {$ENDIF}
  full_fname:=fname + '.dat';
  Assign(f,full_fname);
  repeat
    ClrScr;
{ Формирование меню работы с основным файлом f }
    GoToXY(10, 7);  writeln(UTF8ToConsole('Выберите нужный режим работы      :'));
    GoToXY(10, 8);  writeln(UTF8ToConsole('Создание файла                    1'));
    GoToXY(10, 9);  writeln(UTF8ToConsole('Вывод содержимого файла           2'));
    GoToXY(10, 10); writeln(UTF8ToConsole('Поиск записей по заданным полям   3'));
    GoToXY(10, 11); writeln(UTF8ToConsole('Добавление записей в файл         4'));
    GoToXY(10, 12); writeln(UTF8ToConsole('Удаление записей из файла         5'));
    GoToXY(10, 13); writeln(UTF8ToConsole('Корректировка записей в файле     6'));
    GoToXY(10, 14); writeln(UTF8ToConsole('Выход из программы                7'));
    readln(choose);
    case choose of
  { choose - значение для выбора режима работы с файлом f }
      1: create_data;
      2: out_to_screen;
      3: select_data;
      4: add_data;
      5: delete_data;
      6: find_data;
    end; { end of case }
  until choose=7;
end.

