program integral;
uses
  CRT, FileUtil;
var
  a, b, eps: real;

function Fx(x: real):real; // Подынтегральная функция
{Если потребуется вычислить интеграл для другой функции,
достаточно поменять только один оператор}
begin
  Fx:= sin(x); // Для другой функции меняем здесь
end;

{ Процедура вычисления интеграла по формуле Симпсона
  методом двойного пересчета}
procedure Simpson(a, b, eps: real);
var
  x, h, s, s1: real;
  n, k: integer;
begin
  k:= 0; // при первом вычислении интеграла k=0
  n:= 4; // начальное число точек разбиения интервала (a,b)
  h:= (b - a)/n; // шаг вычисления подынтегральной функции
  while true do
  begin
    x:= a;
    x:= x + h;
    s:= 0;
    while x < (b - h) do
    begin
      s:= s + Fx(x) + 2 * Fx(x + h);
      x:= x + 2 * h;
    end;
    s:= 2 * s;
    s:=(h/3) * (Fx(a) + 2 * Fx(b) + s);
    if k = 0
    then
    begin
      k:= 1;
      s1:= s;
      h:= h/2;
      continue;
    end
    else
    if abs(s1 - s) > eps then
    begin
      s1:= s;
      h:= h/2;
      continue;
    end
    else
      break;
  end;
  writeln(UTF8ToConsole('Значение интеграла s= '), s:0:4);
end; // конец процедуры

begin // начало основной программы
 {задаем интервал на котором вычисляется интеграл}
  a:= 0;
  b:= pi/2;
  eps:= 1e-5; // заданная точность вычисления интеграла
  Simpson(a, b, eps); // вызов процедуры вычисления интеграла
  writeln(UTF8ToConsole('Нажмите любую клавишу'));
  readkey;
end.
